unit SimplePlayerFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, FFBaseComponent, FFBasePlay, FFPlay;

type
  TfrmSimplePlayer = class(TForm)
    lblStatus: TLabel;
    Panel1: TPanel;
    btnOpen: TButton;
    btnPause: TButton;
    btnStep: TButton;
    btnStop: TButton;
    btnWebSite: TButton;
    chkMute: TCheckBox;
    FFPlayer: TFFPlayer;
    OpenDialog1: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnOpenClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure btnStepClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnWebSiteClick(Sender: TObject);
    procedure chkMuteClick(Sender: TObject);
    procedure FFPlayerPosition(Sender: TObject; const APTS: Int64);
    procedure FFPlayerOpenFailed(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSimplePlayer: TfrmSimplePlayer;

implementation

{$R *.dfm}

uses
  ShellAPI,
  MyUtils;

const
  CLibAVPath = 'LibAV';

  SAppTitle = 'Demo of FFPlayer %s';
  SCaption = 'Demo of FFPlayer %s (SimplePlayer) - Delphi FFmpeg VCL Components';
  SWebSiteC = 'http://www.CCAVC.com';
  SWebSiteE = 'http://www.DelphiFFmpeg.com';


  CDialogOptions = [ofHideReadOnly, ofFileMustExist, ofEnableSizing];
  CPictureFiles = '*.BMP;*.GIF;*.JPEG;*.JPG;*.PNG;';
  CAudioFiles = '*.AAC;*.AC3;*.APE;*.DTS;*.FLAC;*.M4A;*.MKA;*.MP2;*.MP3;' +
      '*.MPA;*.MPC;*.OFR;*.OGG;*.RA;*.TTA;*.WAV;*.WMA;';
  CVideoFiles = '*.3GP;*.ASF;*.AVI;*.AVM;*.AVS;*.DAT;*.FLV;*.MKV;*.MOV;' +
      '*.MP4;*.MPEG;*.MPG;*.NSV;*.OGM;*.RM;*.RMVB;*.TP;*.TS;*.VOB;*.WMV;';
  CDialogFilter =
      'Video/Audio/Picture Files|' + CVideoFiles + CAudioFiles + CPictureFiles +
      '|Video Files|' + CVideoFiles +
      '|Audio Files|' + CAudioFiles +
      '|Picture Files|' + CPictureFiles +
      '|All Files|*.*';

var
  SWebSite: string = SWebSiteE;

function DurationToStr(ADuration: Int64): string;
begin
  Result := Format('%.2d:%.2d:%.2d.%.3d',
    [ADuration div AV_TIME_BASE div 60 div 60,
     ADuration div AV_TIME_BASE div 60 mod 60,
     ADuration div AV_TIME_BASE mod 60,
     ADuration mod AV_TIME_BASE * 1000 div AV_TIME_BASE]);
end;

// form create
procedure TfrmSimplePlayer.FormCreate(Sender: TObject);
begin
  // initialize
  Application.Title := Format(SAppTitle, [FFPlayer.Version]);
  Self.Caption := Format(SCaption, [FFPlayer.Version]);

  if SysUtils.SysLocale.PriLangID = LANG_CHINESE then
    SWebSite := SWebSiteC
  else
    SWebSite := SWebSiteE;

  btnWebsite.Hint := SWebSite;
  btnWebsite.ShowHint := True;

  // open dialog setting
  OpenDialog1.Options := CDialogOptions;
  OpenDialog1.Filter := CDialogFilter;

  // disable all fpu exceptions(floating point exceptions):
  //   invalid operation, denormalized, divide by zero, overflow, underflow, inexact/precision
  FFPlayer.DisableFPUExceptions;
end;

procedure TfrmSimplePlayer.FormCloseQuery(Sender: TObject;  var CanClose: Boolean);
begin
  with FFPlayer do
  begin
    // Clear the event handlers
    OnPosition := nil;
    OnState := nil;
    OnVideoHook := nil;
    OnAudioHook := nil;
  end;
end;

// open media file to play
procedure TfrmSimplePlayer.btnOpenClick(Sender: TObject);
begin
  // Load dynamic link libraries
  if not FFPlayer.AVLibLoaded then
  begin
    // TPathFileName = type WideString;
    // FFPlayer.LoadAVLib(const APath: TPathFileName): Boolean;
    // APath: Full path indicates location of FFmpeg DLLs.
    //        It can be empty, let Windows search DLLs in current dir or environment <PATH>
    //if not FFPlayer.LoadAVLib(ExtractFilePath(Application.ExeName) + CLibAVPath) then
    // the routine ExePath() is implemented in unit MyUtils which returns WideString type
    // of ExtractFilePath(Application.ExeName)
    if not FFPlayer.LoadAVLib(ExePath + CLibAVPath) then
    begin
      Panel1.Caption := FFPlayer.LastErrMsg;
      Exit;
    end;
  end;

  // open media file
  if not OpenDialog1.Execute then
    // cancel open file
    Exit;

  // try to open and play media file, render on the custom window specified by handle
  //if not FFPlayer.Open(OpenDialog1.FileName, Panel1.Handle) then
  //  Panel1.Caption := FFPlayer.LastErrMsg;
  FFPlayer.TryOpen(OpenDialog1.FileName, Panel1.Handle);
end;

// toggle pause/resume
procedure TfrmSimplePlayer.btnPauseClick(Sender: TObject);
begin
  FFPlayer.TogglePause;
end;

// step to next frame
procedure TfrmSimplePlayer.btnStepClick(Sender: TObject);
begin
  FFPlayer.StepToNextFrame;
end;

// stop
procedure TfrmSimplePlayer.btnStopClick(Sender: TObject);
begin
  FFPlayer.Stop(True);
  Panel1.Invalidate;
end;

// web site
procedure TfrmSimplePlayer.btnWebSiteClick(Sender: TObject);
  function FromEXE: string;
  var
    S: string;
  begin
    S := ChangeFileExt(ExtractFileName(Application.ExeName), '');
    S := StringReplace(S, '[', '', [rfReplaceAll]);
    S := StringReplace(S, ']', '', [rfReplaceAll]);
    S := StringReplace(S, ' ', '_', [rfReplaceAll]);
    Result := '/?from=exe_' + S;
  end;
begin
  ShellExecute(Application.Handle, 'Open',   {Do not Localize}
    PChar(LowerCase(SWebSite + FromEXE)), '',
    PChar(ExtractFilePath(Application.ExeName)), 1);
end;

// toggle audio mute
procedure TfrmSimplePlayer.chkMuteClick(Sender: TObject);
begin
  FFPlayer.Mute := chkMute.Checked;
end;

// OnPosition event handler
procedure TfrmSimplePlayer.FFPlayerPosition(Sender: TObject; const APTS: Int64);
begin
  lblStatus.Caption := DurationToStr(APTS);
end;

procedure TfrmSimplePlayer.FFPlayerOpenFailed(Sender: TObject);
begin
  Panel1.Caption := FFPlayer.LastErrMsg;
end;

end.
