unit MsgLogFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TfrmMsgLog = class(TForm)
    mmoLog: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure AddMsgLog(AMsg: string; const AShow: Boolean = False);
procedure ShowMsgLog(AShow: Boolean);
procedure ClearMsgLog;

var
  ShowMsgLogCheckBox: TCheckBox = nil;

implementation

{$R *.dfm}

var
  frmMsgLog: TfrmMsgLog = nil;

procedure AddMsgLog(AMsg: string; const AShow: Boolean);
begin
  if not Assigned(frmMsgLog) then
    frmMsgLog := TfrmMsgLog.Create(Application);

  frmMsgLog.mmoLog.Lines.Add(AMsg);

  if AShow then
    if Assigned(ShowMsgLogCheckBox) and not ShowMsgLogCheckBox.Checked then
      ShowMsgLogCheckBox.Checked := True
    else if not frmMsgLog.Visible then
      frmMsgLog.Show;
end;

procedure ShowMsgLog(AShow: Boolean);
begin
  if not Assigned(frmMsgLog) then
    frmMsgLog := TfrmMsgLog.Create(Application);

  if AShow then
    frmMsgLog.Show
  else
    frmMsgLog.Close;
end;

procedure ClearMsgLog;
begin
  if Assigned(frmMsgLog) then
    frmMsgLog.mmoLog.Lines.Clear;
end;

procedure TfrmMsgLog.FormCreate(Sender: TObject);
begin
  Self.Caption := 'Message Log';
end;

procedure TfrmMsgLog.FormShow(Sender: TObject);
begin
  if Assigned(Application.MainForm) then
    if Application.MainForm.WindowState = wsNormal then
    begin
      Self.Left := Application.MainForm.Left;
      Self.Width := Application.MainForm.Width;
      Self.Top := Application.MainForm.Top + Application.MainForm.Height;
    end;
  Self.MakeFullyVisible();
end;

procedure TfrmMsgLog.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if Assigned(ShowMsgLogCheckBox) then
    ShowMsgLogCheckBox.Checked := False;
end;

end.
