unit FFmpegLibInfoFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TfrmFFmpegLibInfo = class(TForm)
    txtPath: TEdit;
    btnSelect: TButton;
    btnShowInfo: TButton;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure btnSelectClick(Sender: TObject);
    procedure btnShowInfoClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmFFmpegLibInfo: TfrmFFmpegLibInfo;

implementation

{$R *.dfm}

uses
{$WARN UNIT_PLATFORM OFF}
  FileCtrl,
  FFLoad,
  FFBaseComponent;

procedure TfrmFFmpegLibInfo.FormCreate(Sender: TObject);
begin
  Application.Title := 'Demo of FFVCL';
  Self.Caption := 'Show FFmpeg Library Information';
  txtPath.Text := ExtractFilePath(Application.ExeName) + 'LibAV';
  txtPath.ReadOnly := True;
  FFLoader.LibraryPath := txtPath.Text;
  with TFFBaseComponent.Create(nil) do
  begin
    Memo1.Text := Edition + ' v' + Version;
    Free;
  end;
  with Memo1.Lines do
  begin
    BeginUpdate;
    try
      Add('');
      Add('Library version number / string of the components:');
      Add('  avcodec   : ' + IntToStr(FFLoader.GetLibBuildVer(avCodec))    + ' / ' + FFLoader.GetLibBuildVerStr(avCodec));
      Add('  avdevice  : ' + IntToStr(FFLoader.GetLibBuildVer(avDevice))   + ' / ' + FFLoader.GetLibBuildVerStr(avDevice));
      Add('  avfilter  : ' + IntToStr(FFLoader.GetLibBuildVer(avFilter))   + ' / ' + FFLoader.GetLibBuildVerStr(avFilter));
      Add('  avformat  : ' + IntToStr(FFLoader.GetLibBuildVer(avFormat))   + ' / ' + FFLoader.GetLibBuildVerStr(avFormat));
      Add('  avutil    : ' + IntToStr(FFLoader.GetLibBuildVer(avUtil))     + ' / ' + FFLoader.GetLibBuildVerStr(avUtil));
      Add('  swresample: ' + IntToStr(FFLoader.GetLibBuildVer(swResample)) + ' / ' + FFLoader.GetLibBuildVerStr(swResample));
      Add('  swscale   : ' + IntToStr(FFLoader.GetLibBuildVer(swScale))    + ' / ' + FFLoader.GetLibBuildVerStr(swScale));
      Add('');
    finally
      EndUpdate;
    end;
  end;
end;

procedure TfrmFFmpegLibInfo.btnSelectClick(Sender: TObject);
var
  LPath: string;
begin
  LPath := txtPath.Text;
  if SelectDirectory('Select LibAV Folder:', '', LPath) then
  begin
    txtPath.Text := LPath;
    FFLoader.Unload(CAllLibraries);
    FFLoader.LibraryPath := LPath;
    if not FFLoader.Load([avCodec, avDevice, avFilter, avFormat, avUtil, swResample, swScale, myUtil]) then
    begin
      Memo1.Lines.Add(FFLoader.LastErrMsg);
      btnShowInfo.Enabled := False;
    end
    else
      btnShowInfo.Enabled := True;
  end;
end;

procedure TfrmFFmpegLibInfo.btnShowInfoClick(Sender: TObject);
begin
  if not FFLoader.Load([avCodec, avDevice, avFilter, avFormat, avUtil, swResample, swScale, myUtil]) then
  begin
    Memo1.Lines.Add(FFLoader.LastErrMsg);
    btnShowInfo.Enabled := False;
  end
  else
  begin
    btnShowInfo.Enabled := True;
    with Memo1.Lines do
    begin
      Add('***************************');
      Add('Libraries loaded in ' + FFLoader.LibraryPath);
      Add('');
      Add('Library version number / string of the loaded library file:');
      Add('  avcodec   : ' + IntToStr(FFLoader.GetLibFileVer(avCodec))    + ' / ' + FFLoader.GetLibFileVerStr(avCodec));
      Add('  avdevice  : ' + IntToStr(FFLoader.GetLibFileVer(avDevice))   + ' / ' + FFLoader.GetLibFileVerStr(avDevice));
      Add('  avfilter  : ' + IntToStr(FFLoader.GetLibFileVer(avFilter))   + ' / ' + FFLoader.GetLibFileVerStr(avFilter));
      Add('  avformat  : ' + IntToStr(FFLoader.GetLibFileVer(avFormat))   + ' / ' + FFLoader.GetLibFileVerStr(avFormat));
      Add('  avutil    : ' + IntToStr(FFLoader.GetLibFileVer(avUtil))     + ' / ' + FFLoader.GetLibFileVerStr(avUtil));
      Add('  swresample: ' + IntToStr(FFLoader.GetLibFileVer(swResample)) + ' / ' + FFLoader.GetLibFileVerStr(swResample));
      Add('  swscale   : ' + IntToStr(FFLoader.GetLibFileVer(swScale))    + ' / ' + FFLoader.GetLibFileVerStr(swScale));
      Add('');

      Add('Library license of the loaded library file:');
      Add('  avcodec   : ' + FFLoader.GetLibLicense(avCodec));
      Add('  avdevice  : ' + FFLoader.GetLibLicense(avDevice));
      Add('  avfilter  : ' + FFLoader.GetLibLicense(avFilter));
      Add('  avformat  : ' + FFLoader.GetLibLicense(avFormat));
      Add('  avutil    : ' + FFLoader.GetLibLicense(avUtil));
      Add('  swresample: ' + FFLoader.GetLibLicense(swResample));
      Add('  swscale   : ' + FFLoader.GetLibLicense(swScale));
      Add('');

      Add('Library configuration of the loaded library file:');
      Add('  avcodec   : ' + FFLoader.GetLibConfiguration(avCodec));
      Add('  avdevice  : ' + FFLoader.GetLibConfiguration(avDevice));
      Add('  avfilter  : ' + FFLoader.GetLibConfiguration(avFilter));
      Add('  avformat  : ' + FFLoader.GetLibConfiguration(avFormat));
      Add('  avutil    : ' + FFLoader.GetLibConfiguration(avUtil));
      Add('  swresample: ' + FFLoader.GetLibConfiguration(swResample));
      Add('  swscale   : ' + FFLoader.GetLibConfiguration(swScale));
      Add('');
    end;

    Memo1.Lines.Add('***available formats in the loaded libraries***');
    FFLoader.GetFormats(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available muxers in the loaded libraries***');
    FFLoader.GetMuxers(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available demuxers in the loaded libraries***');
    FFLoader.GetDemuxers(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available devices in the loaded libraries***');
    FFLoader.GetDevices(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available codecs in the loaded libraries***');
    FFLoader.GetCodecs(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available decoders in the loaded libraries***');
    FFLoader.GetDecoders(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available encoders in the loaded libraries***');
    FFLoader.GetEncoders(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available bit stream filters in the loaded libraries***');
    FFLoader.GetBSFs(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available protocols in the loaded libraries***');
    FFLoader.GetProtocols(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available filters in the loaded libraries***');
    FFLoader.GetFilters(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available pixel formats in the loaded libraries***');
    FFLoader.GetPixFmts(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available standard channel layouts in the loaded libraries***');
    FFLoader.GetLayouts(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available audio sample formats in the loaded libraries***');
    FFLoader.GetSampleFmts(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available stream dispositions in the loaded libraries***');
    FFLoader.GetDispositions(Memo1.Lines);
    Memo1.Lines.Add('');

    Memo1.Lines.Add('***available color names in the loaded libraries***');
    FFLoader.GetColors(Memo1.Lines);
    Memo1.Lines.Add('');
  end;
end;

end.
